	function [G, Z, P, Tg0] = EQ_TG(Tg0, wT, N)
	
	% 	Computes the poles and zeros for an allpole lowpass filter with
	% 	approximately equiripple group delay, where wT is a vector 
	% 	with many more grid points in the passband than N.
	%	Tg0 is an initial guess of the average group delay
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% Author: 			Lars Wanhammar 2010-11-15
	% Modified by: 	 
	% Copyright:		by authors - not released for commercial use
	% Version:			 
	% Known bugs:		The solution many not always be stable
	% Report bugs to:	Wanhammar@gmail.com
	
	wT0 = wT';
	tol = 10^-11; delta = 10; err = 10000;
	for n = 1:100
		Tg = Tg0+0.1*rand;		% Primitive optimization of Tg0
		alfa = (Tg - N)*wT0;
		A = sin(alfa*ones(1,N) + wT0*(1:N));
		b = -sin(alfa); 
		d = A\b;		
		P = roots([1; d]);
		Z = [zeros(length(P),1)];
		G = real(prod(1-P)); 
		Taug = PZ_2_TG_Z(G, Z, P, wT);
		err1 = max(Taug)-min(Taug);	% Minimax error
		if err1 < err
			Tg0 = Tg;
			err = err1;
		end
	end	
	Tg0 = max(PZ_2_TG_Z(G, Z, P, wT));
	
